﻿$ciphers = @(
  "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
  "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
  "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
  "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
  "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384",
  "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"
)

$regPath = "HKLM:\SOFTWARE\Policies\Microsoft\Cryptography\Configuration\SSL\00010002"

if (-not (Test-Path $regPath)) {
  New-Item -Path $regPath -Force | Out-Null
}

Set-ItemProperty -Path $regPath -Name "Functions" -Value $ciphers -Type MultiString

Write-Output "Cipher suite order enforced via policy-backed registry key."